; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F88
; Clock frequency: 4.0 MHz
;
;       The address of 'mydata' (byte) (encode) is 0x2D
;       The address of 'tmp' (word) (global) is 0x2E
	tmp EQU 0x2E
;       The address of 'tpacket' (array 5) (byte) (global) is 0x30
	tpacket EQU 0x30
;       The address of 'crc' (byte) (global) is 0x35
	crc EQU 0x35
;       The address of 'packet' (byte) (global) is 0x36
	packet EQU 0x36
;       The address of 'x1' (byte) (global) is 0x37
	x1 EQU 0x37
;       The address of 'temp1' (byte) (global) is 0x38
	temp1 EQU 0x38
;       The address of 'temp2' (byte) (global) is 0x39
	temp2 EQU 0x39
;       The address of 'temp3' (byte) (global) is 0x3A
	temp3 EQU 0x3A
;       The address of 'humidity1' (byte) (global) is 0x3B
	humidity1 EQU 0x3B
;       The address of 'humidity2' (byte) (global) is 0x3C
	humidity2 EQU 0x3C
;       The address of 'tempsign' (byte) (global) is 0x3D
	tempsign EQU 0x3D
;       The address of 'hum' (word) (global) is 0x3E
	hum EQU 0x3E
;       The address of 'battflag' (byte) (global) is 0x40
	battflag EQU 0x40
;       The address of 'n' (byte) (global) is 0x41
	n EQU 0x41
;       The address of 'x2' (byte) (global) is 0x42
	x2 EQU 0x42
;       The address of 'channel' (byte) (global) is 0x43
	channel EQU 0x43
;       The address of 'rollingcode1' (byte) (global) is 0x44
	rollingcode1 EQU 0x44
;       The address of 'rollingcode2' (byte) (global) is 0x45
	rollingcode2 EQU 0x45
;       The address of 'humidity3' (byte) (global) is 0x46
	humidity3 EQU 0x46
;       The address of 'sensorid1' (byte) (global) is 0x47
	sensorid1 EQU 0x47
;       The address of 'sensorid2' (byte) (global) is 0x48
	sensorid2 EQU 0x48
;       The address of 'sensorid3' (byte) (global) is 0x49
	sensorid3 EQU 0x49
;       The address of 'sensorid4' (byte) (global) is 0x4A
	sensorid4 EQU 0x4A
;       The address of 'unknown' (byte) (global) is 0x4B
	unknown EQU 0x4B
;       The address of 'packetbit' (byte) (global) is 0x4C
	packetbit EQU 0x4C
;       The address of 'chksm' (byte) (global) is 0x4D
	chksm EQU 0x4D
;       The address of 'flags' (byte) (global) is 0x4E
	flags EQU 0x4E
;       The address of 'syncflag' (byte) (global) is 0x4F
	syncflag EQU 0x4F
;       The address of 'crc1' (byte) (global) is 0x50
	crc1 EQU 0x50
;       The address of 'crc2' (byte) (global) is 0x51
	crc2 EQU 0x51
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ARRARG_0 EQU 0x2C
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0010
	ORG 0x0004
	RETFIE
; Begin of program
L0010:
; 1: 'This code simulates an Oregon Scientific temperature sensor, type THGR810
; 2: 'This sensor measures temperature and humidity and trasnmits the data to an Oregon Base using
; 3: '433.92 Mhz
; 4: 'The data is sent in 4 bit nibbles using normal Manchester coding.
; 5: 'The data rate is 1024 Hz which equals Oregon V3 protocol. 1/2 bit time = 488 uS
; 6: 'The RF message data layout is as follows.
; 7: 'A preamble of 6 nibbles consisting of all 1.
; 8: 'A sync nibble of 10.
; 9: 'Sensor data follows.
; 10: 
; 11: 
; 12: 'Sensor data is as follows.
; 13: 'Sensor ID - 4 nibbles, oregon THGR810 has ID of F824
; 14: 'Sensor rolling code  - 1 nibble
; 15: 'Sensor battery flag  - 1 nibble
; 16: 'Sensor temperature  - 3 nibbles format is xx.x deg
; 17: 'Sensor temperature sign - 1 nibble 0 is positive , non zero is negative.
; 18: 'Sensor humidity - 2 nibbles = xx%
; 19: '1 nibble next of which purpose is unknown.****
; 20: 'Sensor CRC which is simply arithmetical sum of data from Sensor data to above data ****
; 21: 'Sensor post amble - 2 nibbles purpose unknown.
; 22: 'Nibbles are sent in order with the LSB of each nibble sent first.
; 23: 'Sensor code for THGR810 sensor is F824.
; 24: 'Transmit data port is PORTA.6 on 16F88.
; 25: 
; 26: 'Notes on the DHT22 temp Sensor.
; 27: 'This Sensor sends 5 bytes of data which are RH1-RH2, Temp1-Temp2, crc
; 28: 'Rh1-Rh2 is a 16 bit word that is divided by 10 to read XX.X %
; 29: 'Temp1-Temp2 is a 16 bit word that is divided by 10 to read XX.X D
; 30: 'If the MSB of Temp1 is 1 , the temp is -, ie below 0D C.
; 31: 'The CRC is the 8 bit sum the 4 data bytes.
; 32: 
; 33: 
; 34: AllDigital
	BSF STATUS,RP0
	CLRF 0x1B
	MOVLW 0x07
	MOVWF 0x1C
; 35: OSCCON.IRCF2 = 1  'Configure PIC for 4 Mhz , Internal Oscillator
	BSF 0x0F,6
; 36: OSCCON.IRCF1 = 1
	BSF 0x0F,5
; 37: OSCCON.IRCF0 = 0
	BCF 0x0F,4
; 38: Define CLOCK_FREQUENCY = 4
; 39: WDTCON.WDTPS3 = 1  'Set WDT prescaler to 65536, gives WDT of 2.3 seconds
	BSF STATUS,RP1
	BCF STATUS,RP0
	BSF 0x05,4
; 40: WDTCON.WDTPS2 = 0
	BCF 0x05,3
; 41: WDTCON.WDTPS1 = 1
	BSF 0x05,2
; 42: WDTCON.WDTPS0 = 1
	BSF 0x05,1
; 43: WDTCON.SWDTEN = 1  'enable WDT
	BSF 0x05,0
; 44: 
; 45: OPTION_REG.PSA = 1  'Assign TMR0 prescaler to WDT
	BCF STATUS,RP1
	BSF STATUS,RP0
	BSF 0x01,3
; 46: OPTION_REG.PS2 = 1  'Set WDT prescaler to 32, gives WDT timeout of 73 swconds.
	BSF 0x01,2
; 47: OPTION_REG.PS1 = 0
	BCF 0x01,1
; 48: OPTION_REG.PS0 = 1
	BSF 0x01,0
; 49: OPTION_REG.T0CS = 0  'enable tmr0
	BCF 0x01,5
; 50: CMCON.CM2 = 1  'Turn off Comparators to reduce power consumption when sleeping.
	BSF 0x1C,2
; 51: CMCON.CM1 = 1  '-
	BSF 0x1C,1
; 52: CMCON.CM0 = 1  '-
	BSF 0x1C,0
; 53: 
; 54: 
; 55: 
; 56: 
; 57: 
; 58: 
; 59: 
; 60: 'Define SIMULATION_WAITMS_VALUE = 1, only used for IDE
; 61: Dim x1 As Byte
; 62: Dim x2 As Byte
; 63: Dim flags As Byte
; 64: Dim syncflag As Byte
; 65: Dim channel As Byte
; 66: Dim rollingcode1 As Byte
; 67: Dim rollingcode2 As Byte
; 68: Dim battflag As Byte
; 69: Dim temp1 As Byte
; 70: Dim temp2 As Byte
; 71: Dim temp3 As Byte
; 72: Dim tempsign As Byte
; 73: Dim humidity1 As Byte
; 74: Dim humidity2 As Byte
; 75: Dim humidity3 As Byte
; 76: Dim sensorid1 As Byte
; 77: Dim sensorid2 As Byte
; 78: Dim sensorid3 As Byte
; 79: Dim sensorid4 As Byte
; 80: Dim unknown As Byte
; 81: Dim crc As Byte
; 82: Dim crc1 As Byte
; 83: Dim crc2 As Byte
; 84: Dim hum As Word
; 85: Dim tmp As Word
; 86: Dim packetbit As Byte
; 87: 
; 88: 
; 89: 
; 90: 
; 91: 
; 92: Dim packet As Byte
; 93: Dim tpacket(5) As Byte
; 94: Dim n As Byte
; 95: Dim chksm As Byte
; 96: 
; 97: 
; 98: TRISA = 0  'port as output
	CLRF 0x05
; 99: TRISB = 0  'port as output
	CLRF 0x06
	BCF STATUS,RP0
; 100: PORTA = 0
	CLRF 0x05
; 101: TRISB.3 = 1  'pin as input
	BSF STATUS,RP0
	BSF 0x06,3
	BCF STATUS,RP0
; 102: 
; 103: 
; 104: 
; 105: flags = 15  '4 bit nibble with all 1s
	MOVLW 0x0F
	MOVWF 0x4E
; 106: syncflag = 10  'sync
	MOVLW 0x0A
	MOVWF 0x4F
; 107: sensorid1 = 0xf  'nibble 0
	MOVLW 0x0F
	MOVWF 0x47
; 108: sensorid2 = 0x8  'nibble 1
	MOVLW 0x08
	MOVWF 0x48
; 109: sensorid3 = 0x2  'nibble 2
	MOVLW 0x02
	MOVWF 0x49
; 110: sensorid4 = 0x4  'nibble 3
	MOVLW 0x04
	MOVWF 0x4A
; 111: channel = 7  'nibble 4 (THGR810 can use channels 1 to 10, but 1 is normally reserved by outside temp sensor.)
	MOVLW 0x07
	MOVWF 0x43
; 112: rollingcode1 = 0x8  'nibble 5
	MOVLW 0x08
	MOVWF 0x44
; 113: rollingcode2 = 0x5  'nibble 6
	MOVLW 0x05
	MOVWF 0x45
; 114: 
; 115: battflag = 0  'nibble 7
	CLRF 0x40
; 116: temp1 = 4  'nibble 8 'Temp=21.4
	MOVLW 0x04
	MOVWF 0x38
; 117: temp2 = 1  'nibble 9
	MOVLW 0x01
	MOVWF 0x39
; 118: temp3 = 2  'nibble 10
	MOVLW 0x02
	MOVWF 0x3A
; 119: tempsign = 0  'nibble 11 0 for positive value, non zero for negative value
	CLRF 0x3D
; 120: humidity1 = 2  'nibble 12 28%
	MOVLW 0x02
	MOVWF 0x3B
; 121: humidity2 = 8  'nibble 13
	MOVLW 0x08
	MOVWF 0x3C
; 122: humidity3 = 0  'Not used in this version.
	CLRF 0x46
; 123: unknown = 0  'nibble 14 not known what this data is for.
	CLRF 0x4B
; 124: 
; 125: TRISB.0 = 0
	BSF STATUS,RP0
	BCF 0x06,0
	BCF STATUS,RP0
; 126: For x1 = 1 To 10  'Flash the led to indicate we have started.
	MOVLW 0x01
	MOVWF 0x37
L0011:
	MOVF 0x37,W
	SUBLW 0x0A
	BTFSS STATUS,C
	GOTO L0012
; 127: 	WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 128: 	PORTB.0 = 1
	BSF 0x06,0
; 129: 	WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 130: 	PORTB.0 = 0
	BCF 0x06,0
; 131: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
	BTFSS STATUS,C
	GOTO L0011
L0012:
; 132: 
; 133: 
; 134: 
; 135: 
; 136: start:  'Main Loop.
L0001:
; 137: ASM:        sleep  'this puts the CPU in low power mode for 73 seconds
	sleep
; 138: 'We wake up here when WDT expires and run the program.
; 139: TRISB.3 = 0  'portb o/p
	BSF STATUS,RP0
	BCF 0x06,3
	BCF STATUS,RP0
; 140: PORTB.3 = 1  'make high
	BSF 0x06,3
; 141: WaitMs 50  'wait
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 142: PORTB.3 = 0
	BCF 0x06,3
; 143: WaitMs 20  'send 20ms low,,wait for DHT22 to respond
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	CALL W001
; 144: TRISB.3 = 1  'portb i/p
	BSF STATUS,RP0
	BSF 0x06,3
	BCF STATUS,RP0
; 145: p1: If PORTB.3 = 1 Then Goto p1  'skip next 3 pulses so we get to the first bit pulse.
L0002:
	BTFSS 0x06,3
	GOTO L0013
	GOTO L0002
L0013:
; 146: p2: If PORTB.3 = 0 Then Goto p2
L0003:
	BTFSC 0x06,3
	GOTO L0014
	GOTO L0003
L0014:
; 147: p3: If PORTB.3 = 1 Then Goto p3
L0004:
	BTFSS 0x06,3
	GOTO L0015
	GOTO L0004
L0015:
; 148: 
; 149: For n = 0 To 4  '5 bytes to receive
	CLRF 0x41
L0016:
	MOVF 0x41,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0017
; 150: packet = 0
	CLRF 0x36
; 151: 
; 152: For packetbit = 1 To 8  '8 bits per data packet
	MOVLW 0x01
	MOVWF 0x4C
L0018:
	MOVF 0x4C,W
	SUBLW 0x08
	BTFSS STATUS,C
	GOTO L0019
; 153: packet = ShiftLeft(packet, 1)  'accumulate bits To make data Byte
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
	CALL SL00
	MOVF R0L,W
	MOVWF 0x36
; 154: 
; 155: loop: If PORTB.3 = 0 Then Goto loop  'Wait for high which is start of data bit.
L0005:
	BTFSC 0x06,3
	GOTO L0020
	GOTO L0005
L0020:
; 156: TMR0 = 0  'clear timer0
	CLRF 0x01
; 157: loop1: If PORTB.3 = 1 Then Goto loop1  'Wait for low which = end of data bit
L0006:
	BTFSS 0x06,3
	GOTO L0021
	GOTO L0006
L0021:
; 158: If TMR0 > 50 Then  'Data 1 = pulse of 70 uS, data 0 = pulse of 28 uS.
	MOVF 0x01,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0022
; 159: 	High packet.0  'Set bit 0 of packet to 1
	BSF 0x36,0
; 160: Else
	GOTO L0023
L0022:
; 161: 	Low packet.0  'set bit 0 of packet to 0
	BCF 0x36,0
; 162: Endif
L0023:
; 163: Next packetbit
	MOVLW 0x01
	ADDWF 0x4C,F
	BTFSS STATUS,C
	GOTO L0018
L0019:
; 164: tpacket(n) = packet
	MOVF 0x41,W
	ADDLW 0x30
	MOVWF FSR
	MOVF 0x36,W
	MOVWF INDF
; 165: Next n
	MOVLW 0x01
	ADDWF 0x41,F
	BTFSS STATUS,C
	GOTO L0016
L0017:
; 166: chksm = (tpacket(0) + tpacket(1) + tpacket(2) + tpacket(3))
;       The address of 'oshonsoft_temp_1' (word) (global) is 0x52
	oshonsoft_temp_1 EQU 0x52
	MOVF 0x30,W
	ADDWF 0x31,W
	MOVWF 0x52
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x32,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x33,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x4D
; 167: If tpacket(4) <> chksm Then Goto error  'last 8 bits of packet are checksum
	MOVF 0x34,W
	SUBWF 0x4D,W
	BTFSC STATUS,Z
	GOTO L0024
	GOTO L0007
L0024:
; 168: hum.HB = tpacket(0)
	MOVF 0x30,W
	MOVWF 0x3F
; 169: hum.LB = tpacket(1)
	MOVF 0x31,W
	MOVWF 0x3E
; 170: tmp.HB = tpacket(2)
	MOVF 0x32,W
	MOVWF 0x2F
; 171: tmp.LB = tpacket(3)
	MOVF 0x33,W
	MOVWF 0x2E
; 172: 
; 173: If tmp.15 = 1 Then  'used to indicate negative temp
	BTFSS 0x2F,7
	GOTO L0025
; 174: 	tmp.15 = 0
	BCF 0x2F,7
; 175: 	tempsign = 1
	MOVLW 0x01
	MOVWF 0x3D
; 176: Else
	GOTO L0026
L0025:
; 177: 	tempsign = 0
	CLRF 0x3D
; 178: Endif
L0026:
; 179: 
; 180: 
; 181: 
; 182: temp3 = tmp / 100  'Convert Temp readings to suit OS data format
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
	MOVF R0H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x3A
; 183: temp2 = (tmp Mod 100) / 10
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x52
	MOVF R2H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF R0L
	MOVF 0x53,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
	MOVF R0H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x39
; 184: temp1 = (tmp Mod 100) Mod 10
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x52
	MOVF R2H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF R0L
	MOVF 0x53,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x52
	MOVF R2H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x38
; 185: humidity2 = hum / 100  'Convert Humidity readings to suit OS data format.
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
	MOVF R0H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x3C
; 186: humidity1 = (hum Mod 100) / 10
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x52
	MOVF R2H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF R0L
	MOVF 0x53,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
	MOVF R0H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x3B
; 187: humidity3 = (hum Mod 100) Mod 10
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x52
	MOVF R2H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF R0L
	MOVF 0x53,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x52
	MOVF R2H,W
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x46
; 188: ASM:        clrwdt  'Clear Watchdog timer
	clrwdt
; 189: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 190: Goto transmit
	GOTO L0008
; 191: 
; 192: error:
L0007:
; 193: 'we should never get here but if we do its most likely that the battery is going flat. DHT22 only works down to 3V
; 194: 'we send all zeroes as data and set the battery flag.
; 195: battflag = 0xc  'set the battery flat flag.
	MOVLW 0x0C
	MOVWF 0x40
; 196: temp1 = 0
	CLRF 0x38
; 197: temp2 = 0
	CLRF 0x39
; 198: temp3 = 0  'set all variables To 0
	CLRF 0x3A
; 199: humidity1 = 0
	CLRF 0x3B
; 200: humidity2 = 0
	CLRF 0x3C
; 201: 
; 202: 
; 203: transmit:
L0008:
; 204: 'Transmitting Code
; 205: 'Calculate the CRC
; 206: 
; 207: crc = sensorid1 + sensorid2 + sensorid3 + sensorid4 + channel + rollingcode1 + rollingcode2 + battflag + temp1 + temp2 + temp3
	MOVF 0x47,W
	ADDWF 0x48,W
	MOVWF 0x52
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x49,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x4A,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x43,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x44,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x45,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x40,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x38,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x39,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x3A,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x35
; 208: crc = crc + tempsign + humidity1 + humidity2 + unknown
	MOVF 0x35,W
	ADDWF 0x3D,W
	MOVWF 0x52
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x3B,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x3C,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	ADDWF 0x4B,W
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x52,W
	MOVWF 0x35
; 209: crc1 = crc And 0xf  'Manchester transmitting code needs data in nibbles
	MOVF 0x35,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	MOVWF 0x50
; 210: crc2 = ShiftRight(crc, 4)
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
	CALL SR00
	MOVF R0L,W
	MOVWF 0x51
; 211: 'The above values are taken from the document Oregon Scientific RF protocol description June 2011.
; 212: 
; 213: 
; 214: 
; 215: 'We start transmitting here.
; 216: PORTB.0 = 1  'Light the Led
	BSF 0x06,0
; 217: PORTA.6 = 1  'turn on tx
	BSF 0x05,6
; 218: WaitUs 1000
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x03
	MOVWF R4H
	CALL Y001
; 219: PORTA.6 = 0
	BCF 0x05,6
; 220: WaitUs 628  'wait 628 us
	MOVLW 0x74
	MOVWF R4L
	MOVLW 0x02
	MOVWF R4H
	CALL Y001
; 221: 
; 222: For x1 = 1 To 6  'Transmit flags
	MOVLW 0x01
	MOVWF 0x37
L0027:
	MOVF 0x37,W
	SUBLW 0x06
	BTFSS STATUS,C
	GOTO L0028
; 223: 
; 224: Call encode(flags)
	MOVF 0x4E,W
	MOVWF 0x2D
	CALL L0009
; 225: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
	BTFSS STATUS,C
	GOTO L0027
L0028:
; 226: 
; 227: Call encode(syncflag)  'Transmit sync
	MOVF 0x4F,W
	MOVWF 0x2D
	CALL L0009
; 228: 
; 229: Call encode(sensorid1)  'Transmit Sensor ID
	MOVF 0x47,W
	MOVWF 0x2D
	CALL L0009
; 230: Call encode(sensorid2)
	MOVF 0x48,W
	MOVWF 0x2D
	CALL L0009
; 231: Call encode(sensorid3)
	MOVF 0x49,W
	MOVWF 0x2D
	CALL L0009
; 232: Call encode(sensorid4)
	MOVF 0x4A,W
	MOVWF 0x2D
	CALL L0009
; 233: 
; 234: Call encode(channel)  'Sensor Channel
	MOVF 0x43,W
	MOVWF 0x2D
	CALL L0009
; 235: 
; 236: Call encode(rollingcode1)  'sensor rolling code
	MOVF 0x44,W
	MOVWF 0x2D
	CALL L0009
; 237: Call encode(rollingcode2)
	MOVF 0x45,W
	MOVWF 0x2D
	CALL L0009
; 238: 
; 239: Call encode(battflag)  'Battery flag
	MOVF 0x40,W
	MOVWF 0x2D
	CALL L0009
; 240: 
; 241: Call encode(temp1)  'Send temperature LSB first
	MOVF 0x38,W
	MOVWF 0x2D
	CALL L0009
; 242: Call encode(temp2)
	MOVF 0x39,W
	MOVWF 0x2D
	CALL L0009
; 243: Call encode(temp3)
	MOVF 0x3A,W
	MOVWF 0x2D
	CALL L0009
; 244: Call encode(tempsign)  '0=Indicates a positive temp,1= negative
	MOVF 0x3D,W
	MOVWF 0x2D
	CALL L0009
; 245: 
; 246: Call encode(humidity1)  'send humidity. LSB first
	MOVF 0x3B,W
	MOVWF 0x2D
	CALL L0009
; 247: Call encode(humidity2)
	MOVF 0x3C,W
	MOVWF 0x2D
	CALL L0009
; 248: Call encode(unknown)
	MOVF 0x4B,W
	MOVWF 0x2D
	CALL L0009
; 249: Call encode(crc1)  'Send CRC checksum LSB first.
	MOVF 0x50,W
	MOVWF 0x2D
	CALL L0009
; 250: Call encode(crc2)
	MOVF 0x51,W
	MOVWF 0x2D
	CALL L0009
; 251: WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 252: PORTA.6 = 0  'Turn off the Transmitter
	BCF 0x05,6
; 253: PORTB.0 = 0  'Turn off the led.
	BCF 0x06,0
; 254: Goto start
	GOTO L0001
; 255: 
; 256: 
; 257: 
; 258: 
; 259: 
; 260: 
; 261: End
L0029:	GOTO L0029
; 262: 
; 263: 
; 264: 'This routine encodes a 4 bit nibble into Manchester format.
; 265: 'Needs some work to convince WMR100 that this is a genuine OS Sensor, but works fine for Arduino Weather Shield + WSDL.
; 266: Proc encode(mydata As Byte)
L0009:
; 267: 
; 268: For x2 = 0 To 3
	CLRF 0x42
L0030:
	MOVF 0x42,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0031
; 269: 	
; 270: If mydata.0 = 1 Then
	BTFSS 0x2D,0
	GOTO L0032
; 271: 	PORTA.6 = 1
	BSF 0x05,6
; 272: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 273: 	PORTA.6 = 0
	BCF 0x05,6
; 274: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 275: Else
	GOTO L0033
L0032:
; 276: 	PORTA.6 = 0
	BCF 0x05,6
; 277: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 278: 	PORTA.6 = 1
	BSF 0x05,6
; 279: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 280: Endif
L0033:
; 281: mydata = ShiftRight(mydata, 1)
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
	CALL SR00
	MOVF R0L,W
	MOVWF 0x2D
; 282: Next x2
	MOVLW 0x01
	ADDWF 0x42,F
	BTFSS STATUS,C
	GOTO L0030
L0031:
; 283: End Proc
	RETURN
; 284: 
; 285: 
; 286: 
; 287: 
; 288: 
; 289: 
; 290: 
; 291: 
; 292: 
; 293: 
; End of program
L0034:	GOTO L0034
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word ShiftLeft Routine
SL01:	BCF STATUS,C
	RLF R0L,F
	RLF R0H,F
SL00:	ADDLW 0xFF
	BTFSC STATUS,C
	GOTO SL01
	RETURN
; Word ShiftRight Routine
SR01:	BCF STATUS,C
	RRF R0H,F
	RRF R0L,F
SR00:	ADDLW 0xFF
	BTFSC STATUS,C
	GOTO SR01
	RETURN
; End of listing
	END
